/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.beans;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.IVWPanelComponent;
import filenet.vw.toolkit.runtime.step.IVWStepProcessor;
import filenet.vw.toolkit.runtime.step.IVWStepProcessorComponent;
import filenet.vw.toolkit.runtime.step.beans.VWButton;
import filenet.vw.toolkit.runtime.step.core.dialog.VWReassignItemDialog;
import filenet.vw.toolkit.runtime.step.core.dialog.VWSaveItemDialog;
import filenet.vw.toolkit.runtime.step.core.history.VWHistoryDialog;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class VWPanel
extends JPanel
implements ActionListener {
    protected VWSession m_vwSession = null;
    protected VWStepElement m_vwStepElement = null;
    protected Vector m_componentList = new Vector();
    protected Container m_parentContainer = null;
    protected JApplet m_parentApplet = null;
    protected Frame m_parentFrame = null;
    protected String m_cancelWarningMsg = VWResource.s_cancelWarning;
    protected String m_confirmCancelMsg = VWResource.s_confirmCancel;
    protected String m_failedToCompleteMsg = VWResource.s_failedCompletingStep;
    protected String m_failedToCancelMsg = VWResource.s_failedCancellingStep;
    protected boolean m_readOnly = false;
    private boolean m_isUserQueue = false;
    private String m_queueName = null;
    private String m_wobNumber = null;
    private VWOpenItem m_openItem = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_parentContainer = sessionInfo.getParentContainer();
            this.m_parentApplet = sessionInfo.getParentApplet();
            this.m_vwSession = sessionInfo.getSession();
            this.m_queueName = sessionInfo.getProperty("queueName");
            this.m_wobNumber = sessionInfo.getProperty("wobNumber");
            if (this.m_vwSession != null) {
                try {
                    Locale browserLocale = sessionInfo.getBrowserLocale();
                    if (browserLocale != null) {
                        this.m_vwSession.setClientLocale(browserLocale);
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            if (this.m_parentContainer != null && this.m_parentContainer instanceof JFrame) {
                this.m_parentContainer.setSize(sessionInfo.getRequestedWidth(), sessionInfo.getRequestedHeight());
            }
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_parentContainer);
            this.m_vwStepElement = this.getStepElement(this.m_queueName, this.m_wobNumber);
            if (this.m_vwStepElement == null) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_unableToOpenStepElement, VWResource.s_failedOpeningStep, 0);
                this.doClose(VWResource.s_unableToOpenStepElement);
                return;
            }
            if (this.m_parentContainer != null && this.m_parentContainer instanceof IVWStepProcessor) {
                ((IVWStepProcessor)((Object)this.m_parentContainer)).setTitle(this.m_vwStepElement.getStepName());
            }
            if (this.m_componentList != null) {
                for (int i = 0; i < this.m_componentList.size(); ++i) {
                    Object obj = this.m_componentList.elementAt(i);
                    if (obj instanceof IVWPanelComponent) {
                        ((IVWPanelComponent)obj).setStepElement(this.m_vwStepElement);
                        continue;
                    }
                    if (!(obj instanceof IVWStepProcessorComponent)) continue;
                    ((IVWStepProcessorComponent)obj).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                }
            }
            this.performExtraLoadOperations();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void destroy() {
        try {
            this.doAbort();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component add(Component newComponent) {
        try {
            if (newComponent == null) {
                return null;
            }
            this.addComponent(newComponent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return super.add(newComponent);
    }

    public void add(Component newComponent, Object constraints) {
        try {
            if (newComponent == null) {
                return;
            }
            this.addComponent(newComponent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        super.add(newComponent, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
            if (VWStringUtils.compare(actionCMD, "F_Cancel") == 0) {
                this.performCancel();
            } else if (VWStringUtils.compare(actionCMD, "F_Complete") == 0) {
                this.performComplete();
            } else if (VWStringUtils.compare(actionCMD, "F_Help") == 0) {
                this.displayHelp();
            } else if (VWStringUtils.compare(actionCMD, "F_History") == 0) {
                this.displayHistory();
            } else if (VWStringUtils.compare(actionCMD, "F_Reassign") == 0) {
                this.performReassign();
            } else if (VWStringUtils.compare(actionCMD, "F_Return") == 0) {
                this.performReturn();
            } else if (VWStringUtils.compare(actionCMD, "F_Save") == 0) {
                this.performSave();
            } else if (VWStringUtils.compare(actionCMD, "F_Status") == 0) {
                this.displayStatus();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void displayHelp() {
        try {
            VWHelp.displayPage(VWHelp.Help_General + "bpfsp018.htm");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void displayHistory() {
        try {
            VWHistoryDialog dialog = new VWHistoryDialog(this.m_parentFrame, this.m_vwStepElement);
            dialog.show();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void doAbort() {
        try {
            if (this.m_vwStepElement != null && !this.m_readOnly) {
                this.m_vwStepElement.doAbort();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void doClose(String closingMessage) {
        try {
            if (this.m_parentContainer != null && this.m_parentContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.m_parentContainer, 201));
            } else if (this.m_parentContainer != null && this.m_parentContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)this.m_parentContainer).closeWindow(closingMessage, VWResource.s_closeWindowMsg);
                this.m_vwStepElement = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void doClose() {
        this.doClose("");
    }

    protected void performExtraCancelOperations() {
    }

    protected void performExtraCompleteOperations() {
    }

    protected void performExtraLoadOperations() {
    }

    protected void performExtraReassignOperations() {
    }

    protected void performExtraReturnOperations() {
    }

    protected void performExtraSaveOperations() {
    }

    private VWStepElement getStepElement(String queueName, String wobNumber) {
        VWStepElement vwStepElement = null;
        VWQueue vwQueue = null;
        VWQueueQuery vwQueueQuery = null;
        Object[] values = new Object[]{wobNumber};
        int queryFlags = 98;
        int confirmValue = 0;
        VWQueueElement vwQueueElement = null;
        VWUserInfo currentUserInfo = null;
        String currentUserName = null;
        String lockedUserName = null;
        try {
            if (this.m_vwStepElement != null) {
                return null;
            }
            if (this.m_vwSession == null) {
                return null;
            }
            vwQueue = this.m_vwSession.getQueue(queueName);
            if (vwQueue == null) {
                return null;
            }
            if (vwQueue.getQueueType() == 2) {
                this.m_isUserQueue = true;
            }
            if ((vwQueueQuery = vwQueue.createQuery("F_WobNum", values, values, queryFlags, null, null, 5)).hasNext()) {
                vwStepElement = (VWStepElement)vwQueueQuery.next();
                try {
                    vwStepElement.doLock(true);
                }
                catch (Exception exLock) {
                    this.m_readOnly = true;
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_readOnlyMessage, VWResource.s_readOnlyNotice, 2);
                }
            } else {
                queryFlags = 99;
                vwQueueQuery = vwQueue.createQuery("F_WobNum", values, values, queryFlags, null, null, 3);
                if (vwQueueQuery.hasNext()) {
                    vwQueueElement = (VWQueueElement)vwQueueQuery.next();
                    if (vwQueueElement != null) {
                        lockedUserName = vwQueueElement.getLockedUser();
                        currentUserInfo = this.m_vwSession.fetchCurrentUserInfo();
                        if (currentUserInfo != null) {
                            currentUserName = currentUserInfo.getName();
                        }
                        if (lockedUserName != null && currentUserName != null) {
                            if (VWStringUtils.compareUsers(this.m_vwSession, lockedUserName, currentUserName)) {
                                confirmValue = JOptionPane.showConfirmDialog(this.m_parentFrame, VWResource.s_userAlreadyLocked, VWResource.s_lockOverrideConfirmation, 0);
                                if (confirmValue == 0 && (vwQueueQuery = vwQueue.createQuery("F_WobNum", values, values, queryFlags = 99, null, null, 5)).hasNext() && (vwStepElement = (VWStepElement)vwQueueQuery.next()) != null) {
                                    try {
                                        vwStepElement.doLock(true);
                                    }
                                    catch (Exception exLock) {
                                        this.m_readOnly = true;
                                        JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_readOnlyMessage, VWResource.s_readOnlyNotice, 2);
                                    }
                                }
                            } else {
                                JOptionPane.showMessageDialog(this.m_parentFrame, lockedUserName, VWResource.s_stepLockedBy, 1);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this.m_parentFrame, lockedUserName, VWResource.s_stepLockedBy, 1);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_unableToOpenStepElement, VWResource.s_failedOpeningStep, 0);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return vwStepElement;
    }

    private void addComponent(Component newComponent) {
        try {
            Component[] childComponents;
            if (newComponent == null) {
                return;
            }
            if (newComponent instanceof IVWPanelComponent) {
                ((IVWPanelComponent)((Object)newComponent)).setStepElement(this.m_vwStepElement);
                if (newComponent instanceof VWButton) {
                    ((VWButton)newComponent).addActionListener(this);
                }
                this.m_componentList.addElement(newComponent);
            } else if (newComponent instanceof IVWStepProcessorComponent) {
                ((IVWStepProcessorComponent)((Object)newComponent)).init(this.m_vwStepElement, this.m_parentFrame, this.m_vwSession);
                this.m_componentList.addElement(newComponent);
            } else if (newComponent instanceof JPanel || newComponent instanceof JTabbedPane) {
                Component[] childComponents2 = ((Container)newComponent).getComponents();
                if (childComponents2 != null) {
                    for (int nIndex = 0; nIndex < childComponents2.length; ++nIndex) {
                        this.addComponent(childComponents2[nIndex]);
                    }
                }
            } else if (newComponent instanceof JScrollPane && (childComponents = ((JScrollPane)newComponent).getViewport().getComponents()) != null) {
                for (int nIndex = 0; nIndex < childComponents.length; ++nIndex) {
                    this.addComponent(childComponents[nIndex]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performCancel() {
        try {
            int selection;
            if (this.m_vwSession == null || this.m_vwStepElement == null) {
                return;
            }
            if (!this.m_readOnly && (selection = JOptionPane.showConfirmDialog(this.m_parentFrame, this.m_cancelWarningMsg, this.m_confirmCancelMsg, 0, 2)) == 1) {
                return;
            }
            this.doAbort();
            this.performExtraCancelOperations();
            if (this.m_vwStepElement.getIsLaunchStep()) {
                this.doClose(VWResource.s_cancelledLaunchingWorkflow);
            } else {
                this.doClose(VWResource.s_cancelledProcessingStep);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), this.m_failedToCancelMsg, 0);
            VWDebug.logException(ex);
        }
    }

    private void performComplete() {
        try {
            if (this.m_vwStepElement == null) {
                return;
            }
            if (this.doSave()) {
                this.performExtraCompleteOperations();
                this.m_vwStepElement.doDispatch();
                if (this.m_vwStepElement.getIsLaunchStep()) {
                    this.doClose(VWResource.s_workflowLaunched);
                } else {
                    this.doClose(VWResource.s_stepCompleted);
                }
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_generalSavingError, this.m_failedToCompleteMsg, 0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), this.m_failedToCompleteMsg, 0);
            VWDebug.logException(ex);
        }
    }

    private void performReassign() {
        try {
            VWParticipant selectedRecipient;
            if (this.m_vwSession == null || this.m_vwStepElement == null) {
                return;
            }
            VWReassignItemDialog reassignDlg = new VWReassignItemDialog(this.m_parentFrame, this.m_vwSession, this.m_isUserQueue);
            reassignDlg.setVisible(true);
            if (reassignDlg.getValue() == 0 && (selectedRecipient = reassignDlg.getSelectedItem()) != null) {
                if (this.doSave()) {
                    this.m_vwStepElement.doReassignByDomain(selectedRecipient.getDomainName(), selectedRecipient.getParticipantName(), reassignDlg.getDelegateFlag(), null);
                    this.performExtraReassignOperations();
                    this.doClose(VWResource.s_stepReassigned.toString(selectedRecipient.getDisplayName()));
                } else {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_generalSavingError, VWResource.s_failedReassigningStep, 0);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_failedReassigningStep, 0);
            VWDebug.logException(ex);
        }
    }

    private void performReturn() {
        try {
            if (this.m_vwStepElement == null) {
                return;
            }
            if (this.doSave()) {
                this.m_vwStepElement.doReturnToSource();
                this.performExtraReturnOperations();
                this.doClose(VWResource.s_stepReturned);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_generalSavingError, VWResource.s_failedReturningStep, 0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_failedReturningStep, 0);
            VWDebug.logException(ex);
        }
    }

    private void performSave() {
        VWQueue sourceQueue = null;
        VWSaveItemDialog saveDlg = new VWSaveItemDialog(new Frame());
        boolean bMoveToInbox = false;
        boolean bMoved = true;
        try {
            if (this.m_vwStepElement == null || this.m_vwSession == null) {
                return;
            }
            sourceQueue = this.m_vwSession.getQueue(this.m_vwStepElement.getCurrentQueueName());
            if (sourceQueue.getQueueType() != 2) {
                saveDlg.setVisible(true);
                switch (saveDlg.getValue()) {
                    case -1: 
                    case 2: {
                        return;
                    }
                    case 0: {
                        bMoveToInbox = true;
                        break;
                    }
                }
            }
            if (this.doSave()) {
                if (bMoveToInbox) {
                    bMoved = false;
                    this.m_vwStepElement.doReassign(this.m_vwSession.fetchCurrentUserInfo().getName(), false, null);
                    bMoved = true;
                } else {
                    this.m_vwStepElement.doSave(true);
                }
                this.performExtraSaveOperations();
                this.doClose(VWResource.s_stepSaved);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_generalSavingError, VWResource.s_failedSavingStep, 0);
            }
        }
        catch (Exception ex) {
            if (bMoved) {
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_failedSavingStep, 0);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_failedMovingStep, 0);
            }
            VWDebug.logException(ex);
        }
    }

    private void displayStatus() {
        try {
            if (this.m_openItem == null) {
                this.m_openItem = new VWOpenItem(this.m_vwSession, this.m_parentContainer, this.m_parentApplet);
            }
            this.m_openItem.openStatusTracker(this.m_queueName, this.m_wobNumber);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean doSave() {
        try {
            if (this.m_componentList == null) {
                return true;
            }
            if (this.m_vwStepElement == null) {
                return false;
            }
            boolean bSuccess = true;
            for (int i = 0; i < this.m_componentList.size(); ++i) {
                Object obj = this.m_componentList.elementAt(i);
                if (obj instanceof IVWPanelComponent) {
                    bSuccess &= ((IVWPanelComponent)obj).doSave();
                    continue;
                }
                if (!(obj instanceof IVWStepProcessorComponent)) continue;
                bSuccess &= ((IVWStepProcessorComponent)obj).doSave();
            }
            if (!bSuccess) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_generalSavingError, VWResource.s_failedSavingStep, 0);
            }
            return bSuccess;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_failedSavingStep, 0);
            VWDebug.logException(ex);
            return false;
        }
    }
}

